#ifndef __LIVECOMMON_H__
#define __LIVECOMMON_H__

#if !defined(LIVE_BROAD_CAST_DLL_DECL) && (defined(WINDOWS) || defined(WIN32))
#ifdef LIVE_BROAD_CAST_DLL_EXPORT
#define LIVE_BROAD_CAST_DLL_DECL __declspec(dllexport)
#else
#define LIVE_BROAD_CAST_DLL_DECL __declspec(dllimport)
#endif
#elif !defined(LIVE_BROAD_CAST_DLL_DECL)
#define LIVE_BROAD_CAST_DLL_DECL
#endif

#ifdef SDK_SIMPLE_INCLUDE
#include "common.h"
#include "NVKit.h"
#else
#include <YCKSdwan/common.h>
#include <YCKit/NVKit.h>
#endif

typedef std::function<void(std::vector<std::string>, int)> LiveCompleteion;

struct LiveInfo {
    std::string roomid;//房间id
    YCKCallVideoPreset VideoPreset;//视频分辨率
    std::string pullurl;//拉流url
};
enum PushVideoType
{
    PushDesktopStream=0,//桌面
    PushCameraStream,//摄像头
    PushDesignatedWndTitle,//指定窗口标题
	PushDesignatedHwnd,//指定窗口句柄
    PushPic,
    PushView,//mac nsview 
    //PushMixStream,//桌面与摄像头混流
    //PushThirdPartyStream,//第三方视频流
};
enum PushAudioType
{
    Push_OnlyMic = 0,//麦克风
    Push_OnlySpeaker,//扬声器
    Push_BothMicAndSpeaker,//麦克风混扬声器
    Push_KitNative,//原生kit会话音频
    Push_ThirdPartyAudioStream,//第三方音频流

};
typedef struct ThirdAuidoType
{
    signed int iSampleRate;//采样率
    signed int iBytesPerSample;//采样字节
    signed int iChanels;//声道数
} ThirdAuidoType;
enum LiveErrorCode
{
    LEC_SUCCESS=0,//success
    LEC_URLERROR=22,//推流URL错误
    LEC_NOAUTH= 607,//无权限
    LEC_ROOMNOEXIST= 620,//房间不存在
    LEC_NOPUSH= 621,//没有推流
    LEC_MAXNUM= 622,//房间达到最大人数
    LEC_PUSHING = 623,//正在推流中
    LEC_STARTPUSH_FAILED=624,//启动推流失败，包括ffmpeg链接失败或者ffmpeg配置错误等
    LEC_SIGNERROR= 866,//签名错误
    LEC_CONNECTTIMEOUT=10053,//服务器连接超时
    LEC_CONNECTCLOSE=10054,//链接被断开
    LEC_INTERNETERROR=867,//服务器连接失败
    LEC_STREAMERROR=888,//音视频流错误导致服务器断开
    LEC_OTHERERROR=999,//未知错误

};

class LiveCallback
{
public:
    virtual void  ConnectCallback(int code) = 0;//连接房间回调
    virtual void  StartCallback(int code ) = 0;//开始推流回调
    virtual void  PushErrorCallback(int code) = 0;//推流失败回调
    virtual void  StopCallback(int code) = 0;//停止推流回调
	virtual ~LiveCallback() = default;
};
class LIVE_BROAD_CAST_DLL_DECL NeuLiveRoomMgr {
public:
    //NeuLiveRoomMgr() = default;
    virtual ~NeuLiveRoomMgr() = default;
    virtual void RegCallback(std::shared_ptr<LiveCallback> lcb) = 0;//注册回调
    virtual void ConnectLiveRoom(std::string roomid, YCKCallVideoPreset videoRreset = YCKCallVideoPreset480p)=0;//客户端提供roomid，获取远端服务器推流地址
    virtual void SwitchPushVideoType(PushVideoType type = PushDesktopStream) = 0;//切换推流视频源，默认桌面
    virtual bool SetDesignatedWindowTitle(std::string wintitle) = 0;//(如需要展示指定窗口，请调用SwitchPushVideoType(PushDesignatedWndTitle)后设置窗口名称，否则默认仍为桌面 )弃用
	virtual bool SetDesignatedHwnd(intptr_t window_id) = 0;//（设置要录制的窗口句柄 ）弃用
    virtual void StartPushStream(bool bUseCQP = false) = 0;//开始推流
    virtual void SwitchPushAudioType(PushAudioType type)=0;
    virtual void SetThirdAudioType(ThirdAuidoType type) = 0;//设置第三方流格式
    virtual void WriteThirdAudioStream(const char* buf, int len) = 0;//第三方音频流写入
    virtual void StopPushStream() = 0;//停止推流
    virtual void DisconnectLiveRoom(std::string roomid, LiveCompleteion completeion = 0) = 0;//与房间断开连接，结束直播和录制
    virtual bool IsStartedPush() = 0;//是否已经推流
    virtual bool SelectWindow(intptr_t window_id) =0;
    virtual bool SelectScreen(intptr_t screen_id) =0;
    virtual bool SelectView(intptr_t view_id) = 0;//用于推流mac的nsview
    virtual bool SelectPicture(std::string picpath) = 0;
    virtual bool GetWindows(std::vector<intptr_t>& window_ids, std::vector<std::string>& titles) =0;
    virtual bool GetScreens(std::vector<intptr_t>& screen_ids, std::vector<std::string>& names) =0;
	virtual void setPushUrl(const std::string pushUrl) = 0;
    virtual std::string getPushUrl() = 0;
    virtual void setLiveTimeout(int contimeout = 10, int rwtimeout = 10) = 0;//单位：s
    //测试
    virtual void setWHBeforePush(int width, int height) = 0;
    //非正式 测试api
	virtual void createLiveRoom(LiveCompleteion completeion, 
		const std::string& title, const std::string& details, const int64_t& starttime, const int64_t& endtime,
		const int& enablePlayback, bool enableChat = true, bool allowWatcherChat = true, bool allowAnonymousChat = true,
		bool messageNeedCheck = true, int resolutionMode=1, std::vector<std::string> userPhones = std::vector<std::string>(),
		std::string password = "", bool foregin = false, bool replayTranscode=false, std::vector<std::string> assistants = std::vector<std::string>(),
        const std::string& enterpriseId="") = 0;
	virtual void getLiveRoomPushUrl(const std::string& roomID, LiveCompleteion completeion)=0;
	virtual void getLiveRoomPullUrl(const std::string& roomID, LiveCompleteion completeion, const std::string password = "") =0;
	virtual void endLiveRoom(const std::string& roomID, LiveCompleteion completeion) = 0;
	virtual void getNotEndLiveRoomList(LiveCompleteion completeion) = 0;
    

};
std::shared_ptr<NeuLiveRoomMgr> getNeuLiveMgr(NVKit * kit);//使用kit中的getLivePushMgr

#endif // !__LIVECOMMON_H__
