//
// Created by shixiaobo on 2020/7/9.
//

#ifndef NEOTRINO_SCREENRECORDERPROTOCOL_H
#define NEOTRINO_SCREENRECORDERPROTOCOL_H

#include "ScreenRecorderExport.h"
#include "ScreenGrabProtocol.h"
#ifdef SDK_SIMPLE_INCLUDE
#include "YCKCallManagerProtocol.h"
#include "YCKExternalAudioFilter.h"
#else
#include <YCKit/Call/YCKCallManagerProtocol.h>
#include <YCKit/YCKExternalAudioFilter.h>
#endif // SDK_SIMPLE_INCLUDE
#include <string>
#include <memory>
// 模拟 功能按钮，控制后台操作
enum RecorderButton{
    cast_screen = 1,
    record
};

class DLL_DECL_SR ScreenRecorderProtocol : public ScreenGrabProtocol {
public:
	static std::shared_ptr<ScreenRecorderProtocol> init();
    virtual int64_t uid() const = 0;

    virtual std::shared_ptr<YCKCallManagerProtocol> getCallManager() const = 0;
    virtual WeakYCKExternalAudioFilterPtr getExternalAudioFilter() = 0;
    virtual void setExternalAudioFilter(WeakYCKExternalAudioFilterPtr filter) = 0; 
    virtual void setMute(BOOL on) = 0;
    //return false if failed to make screen recorder ready.
    virtual bool ready(const std::string & title, const std::string & appId, const std::string & appKey,int64_t uid,std::string atoken,std::string srv_dev="prod", std::string path="sr") = 0;
    virtual void setVideoMaxAvergeBitrate(int bitrateInKBps) = 0;
    /****************投屏部分*****************/
    /**
     * 开始投屏-其实是邀请，这里在邀请之前传入RecorderButton，告诉sdk要开启投屏功能
     */
    virtual void start_cast_screen(RecorderButton button) = 0;

    /**
    * 结束投屏
    */
    virtual void stop_cast_screen() = 0;

    /****************投屏部分-end*****************/


    /****************录制部分*****************/
    /**
     * 开始录制
     */
    virtual void start_record(RecorderButton button) = 0;

    /**
     * 暂停录制，预留，目前不实现
     */
    virtual void pause_record() = 0;

    /**
     * 停止录制
     */
    virtual void stop_record() = 0;

    /****************录制部分-end*****************/
    virtual ~ScreenRecorderProtocol()=default;

    virtual bool SetScreenShareMode(ScreenShareMode mode) = 0;
    virtual ScreenShareMode GetScreenShareMode() = 0;
};

#endif //NEOTRINO_SCREENRECORDERPROTOCOL_H
