/*
 * YCKAbstractWhiteboard.h
 *
 *  Created on: Jul 9, 2020
 *      Author: dengminhao@axzt.net
 */
#pragma once
#ifndef YCKIT_YCKIT_DATA_YCKABSTRACTWHITEBOARD_H_
#define YCKIT_YCKIT_DATA_YCKABSTRACTWHITEBOARD_H_


#ifdef SDK_SIMPLE_INCLUDE
#include "common.h"
#include <memory>
#include "NVKitExport.h"
#else
#include <YCKSdwan/common.h>
#include <YCKit/NVKitExport.h>
#endif

class YCKAbstractWhiteboard;
class YCKWhiteboardCommand;
class NVKit;
class YCKCallManagerProtocol;

class YCKWhiteboardDelegate{
public:
virtual void sendCommand(std::shared_ptr<YCKAbstractWhiteboard> wb, std::shared_ptr<YCKWhiteboardCommand> command)=0;
virtual void sendCommand(std::shared_ptr<YCKAbstractWhiteboard> wb, std::shared_ptr<YCKWhiteboardCommand> command, int64_t to_uid)=0;
virtual ~YCKWhiteboardDelegate()=default;
};

class DLL_DECL YCKAbstractWhiteboard: public std::enable_shared_from_this<YCKAbstractWhiteboard>
{
public:
    YCKAbstractWhiteboard();
	int 	wbid;
	std::weak_ptr<YCKWhiteboardDelegate> delegate;

public:
    void registerWhiteboard(NVKit *sdk);
    void registerWhiteboard(std::shared_ptr<NVKit> sdk);
    void unRegisterWhiteboard();
	virtual void receiveCommand(std::shared_ptr<YCKWhiteboardCommand> command) = 0; //收到其他方的指令
	virtual void sendCommand(std::shared_ptr<YCKWhiteboardCommand> command); //发送指令
	virtual void sendCommand(std::shared_ptr<YCKWhiteboardCommand> command, int64_t to_uid);
    // 压缩数据
    // input为输入数据
    // output为压缩后的数据
    // 返回值是压缩之后的长度
    int64_t gzippedData(const std::vector<char>& input, std::vector<char>& output);

    // 解压缩数据
    int64_t gunzippedData(const std::vector<char>& input, std::vector<char>& output);
	virtual ~YCKAbstractWhiteboard()=default;

protected:
    std::weak_ptr<YCKCallManagerProtocol> callmanager_;
    bool reg_;
};


#endif /* YCKIT_YCKIT_DATA_YCKABSTRACTWHITEBOARD_H_ */
