//
//  YCKCustomSignal.h
//  YCKit
//
//  Created by 徐家骏 on 2019/11/11.
//  Copyright © 2019 徐家骏. All rights reserved.
//

#pragma once

#ifdef SDK_SIMPLE_INCLUDE
#include "common.h"
#include "nlohmann/json.hpp"
#include "YCKitExport.h"
#else
#include <YCKSdwan/common.h>
#include "YCKExternal/YCKExternal/json/single_include/nlohmann/json.hpp"
#include <YCKit/YCKitExport.h>
#endif

using nlohmann::json;

enum YCKCustomSignalType {
    YCKCustomSignalTypeNoop = 0,
};

class YCKSignalPacket;

class DLL_DECL YCKCustomSignal {
public:
    YCKCustomSignal();

public:
    PROPERTY(nonatomic)   YCKCustomSignalType signal = YCKCustomSignalTypeNoop;
    PROPERTY(nonatomic)   int64_t from = 0;
    PROPERTY(nonatomic)   int64_t to = 0;
    PROPERTY(nonatomic)   int64_t session_id = 0;
    PROPERTY(nonatomic)   uint32_t ttl;
    PROPERTY(nonatomic)   int64_t timestamp;
    PROPERTY(nonatomic, strong) std::string uuid;
    PROPERTY(nonatomic, strong) std::shared_ptr<json> option;
    PROPERTY(nonatomic, strong) std::shared_ptr<json> info;

    std::shared_ptr<YCKSignalPacket> packetOfCustomSignal();

    static std::shared_ptr<YCKCustomSignal> signalFromPacket(std::shared_ptr<YCKSignalPacket> packet);

    static std::shared_ptr<YCKCustomSignal> signalFromPacket(const YCKSignalPacket &packet);

    std::string signalString();

    static std::shared_ptr<YCKCustomSignal> init();
};
