/*
 * YCKWhiteboardCommand.h
 *
 *  Created on: Jul 9, 2020
 *      Author: dengminhao@axzt.net
 */
#pragma once
#ifndef YCKIT_YCKIT_DATA_YCKWHITEBOARDCOMMAND_H_
#define YCKIT_YCKIT_DATA_YCKWHITEBOARDCOMMAND_H_

#ifdef SDK_SIMPLE_INCLUDE
#include "common.h"
#include <memory>
#include "YCKitExport.h"
#include "nlohmann/json.hpp"
#else
#include <YCKSdwan/common.h>
#include <YCKit/YCKitExport.h>
#include "YCKExternal/YCKExternal/json/single_include/nlohmann/json.hpp"
#endif

class YCKWhiteboardCommand {
public:
	//binary data. All other fields read from json. Binary data doesn't. it will be set/put directly.
	std::vector<char>                                  data;
    // YCKWhiteboardCommandType
	PROPERTY(nonatomic)    int                         command = 0;
	// YCKWhiteboardElementType
    PROPERTY(nonatomic)    int                         etype;
	PROPERTY(nonatomic)    int32_t                     wbid =0;
	PROPERTY(nonatomic)    int32_t                     pageid =0;
	PROPERTY(nonatomic)    int32_t                     eid =0;
	PROPERTY(nonatomic)    int64_t                     uid =0; //用户id，这个在接收到的时候根据from自己设置，发送的时候也不用设置
	PROPERTY(nonatomic)    int64_t                     timestamp =0; //创建时间
	PROPERTY(nonatomic)    int32_t                     eoe =0;  //对于多个消息合并成一个操作的，比如画线条，移动图像，这个标识最终结束
	//请在子类转换成实际UIRect

	//这两项本地计算使用，并不序列化和网络传输.请在子类做定义
	//@property (nonatomic)          CGRect                normRect;
	//@property (nonatomic, strong)  NSData               *normData;

	//as ios dict.
	nlohmann::json full_json;

DLL_DECL YCKWhiteboardCommand();

#ifndef SDK_SIMPLE_INCLUDE
	static std::shared_ptr<YCKWhiteboardCommand> initWithData(shared_const_buffer data);
	shared_const_buffer toData()const;
#endif

DLL_DECL std::string toString() const;
DLL_DECL void readFromString(const std::string& jsonCommand);

};

#ifndef SDK_SIMPLE_INCLUDE
void to_json(nlohmann::json& j, const YCKWhiteboardCommand& p);
void from_json(const nlohmann::json& j, YCKWhiteboardCommand& p);
#endif
#endif /* YCKIT_YCKIT_DATA_YCKWHITEBOARDCOMMAND_H_ */
