#ifndef NV_DIRECTXHELPER_H
#define NV_DIRECTXHELPER_H

#ifdef SDK_SIMPLE_INCLUDE
#include "../YCKitExport.h"
#else
#include "YCKit/YCKitExport.h"
#endif

//#ifndef Q_OS_WINRT
#ifndef D3D11_MAJOR_VERSION
#include <d3d9.h>
#endif
//#endif


#ifndef DX_LOG_COMPONENT
#define DX_LOG_COMPONENT "DirectX"
#endif //DX_LOG_COMPONENT
#define DX_ENSURE(f, ...) DX_CHECK(f, return __VA_ARGS__;)
#define DX_WARN(f) DX_CHECK(f)
#define DX_ENSURE_OK(f, ...) DX_CHECK(f, return __VA_ARGS__;)
#define DX_CHECK(f, ...) \
    do { \
        HRESULT hr = f; \
        if (FAILED(hr)) { \
            LOGW(DX_LOG_COMPONENT " error@%d. " #f ": (0x%x) HRESULT:%d",__LINE__,hr,hr); \
            __VA_ARGS__ \
        } \
    } while (0)


template <class T> void SafeRelease(T **ppT) {
  if (ppT != nullptr && *ppT != nullptr) {
    (*ppT)->Release();
    *ppT = NULL;
  }
}

namespace DXHelper {
DLL_DECL const char* vendorName(unsigned id);

//#ifndef Q_OS_WINRT
#ifndef D3D11_MAJOR_VERSION
DLL_DECL IDirect3DDevice9* CreateDevice9Ex(HINSTANCE dll, IDirect3D9Ex **d3d9ex, D3DADAPTER_IDENTIFIER9* d3dai = NULL);
DLL_DECL IDirect3DDevice9* CreateDevice9(HINSTANCE dll, IDirect3D9 **d3d9, D3DADAPTER_IDENTIFIER9* d3dai = NULL);
#endif
//#endif //Q_OS_WINRT
} //namespace DXHelper


#endif //NV_DIRECTXHELPER_H
