#ifndef NVSURFACEINTEROPFACTORY_H
#define NVSURFACEINTEROPFACTORY_H

#ifdef SDK_SIMPLE_INCLUDE
#include "../YCKitExport.h"
#else
#include "YCKit/YCKitExport.h"
#endif

#include <string>

class SurfaceInterOp;

namespace NVSurfaceInterop{
    enum Type{
        INTEROP_CV,
        INTEROP_D3D11,
        INTEROP_D3D9,
        INTEROP_CUDA,
        INTEROP_VAAPI,
        INTEROP_INVALID
    };

    //实际上会尽量把opengl无关的内容放入SDK。所以未必是SurfaceInterOp需要在Qt内被build。
    //需要各个子类加对应的build方法。
    //
    struct SurfaceInterOpBuilder{
        virtual SurfaceInterOp* build() = 0;
        virtual std::string name() const = 0;
        virtual ~SurfaceInterOpBuilder()=default;
    };

    DLL_DECL SurfaceInterOpBuilder* get_creator(Type type);
    DLL_DECL bool set_creator(Type type,SurfaceInterOpBuilder* v);
}
#endif // NVSURFACEINTEROPFACTORY_H
