#pragma once
/*
 * NVVideoSize.h
 *
 *  Created on: May 14, 2020
 *      Author: dengminhao@axzt.net
 */

#ifndef YCKIT_YCKIT_VIDEO_NVVIDEOSIZE_H_
#define YCKIT_YCKIT_VIDEO_NVVIDEOSIZE_H_

enum NVVideoSizeOrientation{
	landscape = 0,
	portrait = 1
};


class NVVideoSize{
public:
	int width;
	int height;

	inline NVVideoSize():width(0),height(0){}
	inline NVVideoSize(int w,int h):width(w),height(h){}
    inline NVVideoSize(const NVVideoSize& size) : width(size.width), height(size.height) {}

    inline bool isZero() const {
        return (width == 0 && height == 0);
    }

	static inline bool isPortrait(NVVideoSize aSize){
		return aSize.width < aSize.height;
	}

	static inline NVVideoSizeOrientation getOrientation(NVVideoSize aSize) {
        return isPortrait(aSize)?portrait:landscape;
    }

	static inline NVVideoSize toReverseOrientation(NVVideoSize aSize) {
        return NVVideoSize(aSize.height,aSize.width);
    }

    static inline NVVideoSize getSizeInOrientation(NVVideoSize aSize,NVVideoSizeOrientation ornt) {
        if (getOrientation(aSize) == ornt) return aSize;
        return toReverseOrientation(aSize);
    }
};

inline bool operator==(const NVVideoSize& lhs, const NVVideoSize& rhs) {
    return (lhs.width == rhs.width && lhs.height == rhs.height);
}

inline bool operator!=(const NVVideoSize& lhs, const NVVideoSize& rhs) {
    return !(lhs == rhs);
}


#endif /* YCKIT_YCKIT_VIDEO_NVVIDEOSIZE_H_ */
