﻿/*
 * YCKDeviceInfo.h
 *
 *  Created on: Jun 13, 2020
 *      Author: dengminhao@axzt.net
 */

#ifndef YCKSDWAN_YCKSDWAN_UTILS_YCKDEVICEINFO_H_
#define YCKSDWAN_YCKSDWAN_UTILS_YCKDEVICEINFO_H_
#include <string>
#include <vector>
#include <map>

#ifdef SDK_SIMPLE_INCLUDE
#include "common.h"
#else
#include <YCKSdwan/common.h>
#endif

class DLL_DECL_SDWAN YCKDeviceInfo{
public:
    static bool GetGPUList(std::vector<uint32_t>& vids, std::vector<std::string>& names,
        std::vector<std::string>& hwids, std::vector<std::string>& driver_versions,
        std::vector<bool>& driver_installed);

	virtual std::string platform();
	virtual std::string deviceName();
	virtual int cpu_core_number();
	virtual float mem_usage();
    virtual uint64_t mem_peak_usage();
    virtual std::string virtual_mem_info(bool refresh);
    inline uint64_t free_virtual_mem() { return free_virtual_mem_; }

	virtual void get_memory_info(uint64_t& avail_mem, uint64_t& total_mem);
	virtual void get_gpu_info(std::vector<std::string>& gpu_list);
	virtual std::string get_os_version();
	virtual std::string get_os_name();
	virtual std::string get_ip_info();
	virtual std::string get_cpu_info();
	virtual std::string get_app_version();
	virtual std::string get_sdk_version();
	virtual std::string get_screen_resolution();

	virtual float cached_cpu_usage();
	virtual float cached_total_cpu_usage();

	virtual int get_os_bit();

	inline uint64_t mem_vitural_size() {return mem_vsize;}
	virtual bool isLowEndDevice();
	virtual void setForceLowEnd(bool forced);
	inline int isCPULimited() {return is_CPU_Limited;}

	virtual ~YCKDeviceInfo()=default;

	static YCKDeviceInfo sharedInst;

private:
	bool is_gpu(const std::string& gpu_info);
	virtual float cpu_usage();
	virtual float total_cpu_usage();

private:
	std::string platform_name;
	std::string device_name;
	int cpu_core_numbers = 0;
	float mem_ug = 0;
    uint64_t mem_peak_usage_ = 0;
    uint64_t mem_vsize = 0;
    std::string virtual_mem_info_;
    uint64_t free_virtual_mem_ = 0;

	uint64_t avail_mem;
	uint64_t total_mem;
	std::vector<std::string> gpu_list;
	std::string os_version;
	std::string os_name;
	std::string ip_info;
	std::string cpu_info;
	std::string app_version;
	std::string sdk_version;

	float cached_cpu_ug = 0;
	float cached_total_cpu_ug = 0;
	int lowEndDevice = -1;
	int is_CPU_Limited = -1;
};


#endif /* YCKSDWAN_YCKSDWAN_UTILS_YCKDEVICEINFO_H_ */
