//
// Created by shixiaobo on 2020/8/13.
//

#ifndef NEOTRINO_SCREENMONITORMANAGERPROTOCOL_H
#define NEOTRINO_SCREENMONITORMANAGERPROTOCOL_H

#ifdef SDK_SIMPLE_INCLUDE
#include "common.h"
#include "YCKGlobalDefs.h"
#include "ScreenRecorderExport.h"
#include "ScreenGrabProtocol.h"
#else
#include <YCKSdwan/common.h>
#include <YCKit/YCKGlobalDefs.h>
#include <ScreenRecorder/ScreenRecorderExport.h>
#include <ScreenRecorder/ScreenGrabProtocol.h>
#endif
enum MonitorCallbackStatus{
    onStartMonitorSuccess = 1,
    onStartMonitorFail,
    onStopMonitorSuccess,
    onStopMonitorFail
};
class ScreenMonitorManagerDelegate{
public:
    virtual void onStart(MonitorCallbackStatus status) = 0;
    virtual void onStop(MonitorCallbackStatus status) = 0;
    virtual void onMonitor(std::string path,std::string thumbPath) = 0;
};


class DLL_DECL_SR ScreenMonitorManagerProtocol : public ScreenGrabProtocol {
public:
    /**
     *
     * @param delegate 回调
     * @param period 周期 单位s
     * @return
     */
    static std::shared_ptr<ScreenMonitorManagerProtocol> init(std::shared_ptr<ScreenMonitorManagerDelegate> delegate);

    virtual void initScreenOptions(int x,int y,int width,int height) = 0;
    /**
     * 监控开始
     */
    virtual void start(std::string appName, std::string dir,int period = 60, int dstWidth = 1280,int dstHeight = 720, int quality = 90) = 0;

    /**
     * 监控结束
     */
    virtual void stop() = 0;

    /**
     * 添加结果回调
     * @param delegate
     */
    virtual void addDelegate(std::shared_ptr<ScreenMonitorManagerDelegate> delegate) = 0;

    virtual ~ScreenMonitorManagerProtocol() = default;
};

#endif //NEOTRINO_SCREENMONITORMANAGERPROTOCOL_H
