/*
 * YCKUIApplication.h
 *
 *  Created on: Jun 8, 2020
 *      Author: dengminhao@axzt.net
 */
#pragma once
#ifndef YCKSDWAN_YCKSDWAN_UIPROXY_YCKUIAPPLICATION_H_
#define YCKSDWAN_YCKSDWAN_UIPROXY_YCKUIAPPLICATION_H_

#ifdef SDK_SIMPLE_INCLUDE
#include "common.h"
#else
#include <YCKSdwan/common.h>
#endif
#include "YCKMemberUIStruct.h"
#include <functional>
#include <memory>

/**
 * the implementation of this class should be set by App.
 * Or by OS.
 */
class DLL_DECL_SDWAN YCKUIApplication{
	//all functions should get information in UI thread
	//and post completion callback to normal queue
public:

	virtual void getUISize(std::function<void(int width,int height)> completion);

	virtual void isBackground(std::function<void(bool is_backgroud)> completion);

	/**
	 * completion: 1st parameter: displayedInfo: the UIStruct of displayed users.
	 *             2st parameter: willnotDisplayUsers: the users that will not display in a short time( less than 500ms. but display now).
	 */
	virtual void getDisplayedUserVideoInfo(std::vector<int64_t> toCheckUsers,
			std::function<void(std::shared_ptr<std::vector<YCKMemberUIStruct>> displayedInfo,std::vector<int64_t> willnotDisplayUsers)> completion);


	YCKUIApplication();
	virtual ~YCKUIApplication();
protected:
	void * self;
	void createSelf();
	void destroySelf();
};

//forward declare. for SDK uses don't include YCKDispatch.h
DLL_DECL_SDWAN void _post_to_normal_q_helper(std::function<void(void)> f);

#endif /* YCKSDWAN_YCKSDWAN_UIPROXY_YCKUIAPPLICATION_H_ */
