#ifndef QTAV_D3D9VPP_H
#define QTAV_D3D9VPP_H
#ifdef SDK_SIMPLE_INCLUDE
#include "../YCKitExport.h"
#include "NVColor.h"
#else
#include "YCKit/YCKitExport.h"
#include "../NVColor.h"
#endif
#include "dxcompat.h"
#include <d3d9.h>
#include <dxvahd.h>
#include <wrl/client.h>

using namespace Microsoft::WRL;
// https://msdn.microsoft.com/en-us/library/windows/desktop/ee663581(v=vs.85).aspx

namespace dx {

class DLL_DECL DXVAHDVP
{
public:
    // brightness, contrast, hue, saturation, rotation, source/dest rect
    DXVAHDVP(ComPtr<IDirect3DDevice9> dev);
    void setOutput(IDirect3DSurface9* surface);
    void setSourceRect(const RECT& r);
    // input color space and range
    void setColorSpace(ColorSpace value);
    void setColorRange(ColorRange value);
    bool process(IDirect3DSurface9 *surface);
	bool is_create_processor_fail() const { return create_processor_fail; }
private:
    bool ensureResource(UINT width, UINT height, D3DFORMAT format);

    ComPtr<IDirect3DDevice9Ex> m_dev;
    ComPtr<IDXVAHD_Device> m_viddev;
    ComPtr<IDXVAHD_VideoProcessor> m_vp;
    ComPtr<IDirect3DSurface9> m_out;
    UINT m_w, m_h; //enumerator
    ColorSpace m_cs;
    ColorRange m_range;
    RECT m_srcRect;
    PDXVAHD_CreateDevice fDXVAHD_CreateDevice;
    D3DFORMAT m_fmt;
	bool create_processor_fail = false;
};
} //namespace dx

#endif //QTAV_D3D9VPP_H
