﻿#ifndef YCK_CALL_DEVICE_MANAGER_H
#define YCK_CALL_DEVICE_MANAGER_H
#ifdef SDK_SIMPLE_INCLUDE
#include "common.h"
#include "YCKGlobalDefs.h"
#include "YCKitExport.h"
#include "YCKDeviceID.h"
#include "YCKAudioDeviceVolumeDelegate.h"
#include "YCKTestSpeakerDelegate.h"
#else
#include <YCKSdwan/common.h>
#include <YCKit/YCKGlobalDefs.h>
#include <YCKit/YCKitExport.h>
#include <YCKit/YCKDeviceID.h>
#include "YCKit/Audio/YCKAudioDeviceVolumeDelegate.h"
#include "YCKit/Audio/YCKTestSpeakerDelegate.h"
#endif

class YCKDeviceNotify
{
public:
	virtual void onDefaultInputChange() = 0;
	virtual void onDefaultOutputChange() = 0;

    virtual void onCameraChanged() = 0;
    virtual void onAudioInputChanged() = 0;
    virtual void onAudioOutputChanged() = 0;
};

class YCKDeviceManager
{
public:
	virtual void addDelegate(std::shared_ptr<YCKDeviceNotify> delegate) = 0;
	virtual void removeDelegate(std::shared_ptr<YCKDeviceNotify> delegate) = 0;

//更新设备信息
    virtual void cleanDeviceInfo() = 0;
	virtual void updateDeviceInfo() = 0;
	virtual void setForceVideoCaptureOutputPixelFormat(int pixel_format) = 0;
	virtual void setDeviceTestMode(bool enable) = 0;
	//摄像头设备
	virtual bool selectCamera(const YCKDeviceId& selected) = 0;
	virtual bool selectDefaultCamera() = 0;
	virtual std::vector<YCKDeviceId> getCameraList() = 0;
	virtual YCKDeviceId getSelectedCamera() = 0;
	virtual bool setCameraOn() = 0;
	virtual void setCameraOff() = 0;
	virtual bool getCameraOn() = 0;
	//扬声器设备
	virtual bool selectSpeaker(const YCKDeviceId& selected) = 0;
	virtual bool selectDefaultSpeaker() = 0;
	virtual std::vector<YCKDeviceId> getSpeakerList() = 0;
	virtual YCKDeviceId getSelectedSpeaker() = 0;
	virtual bool setSpeakerOn() = 0;
	virtual void setSpeakerOff() = 0;
	virtual bool getSpeakerOn() = 0;
	virtual float getSpeakerVolume(const YCKDeviceId& devId) = 0;
	virtual void setSpeakerVolume(const YCKDeviceId& devId, float volume) = 0;// 0.0 (silence) => 1.0 (full level)
	virtual bool testSpeakerStart(const std::string& pcm_file,
		std::shared_ptr<YCKAudioDeviceVolumeDelegate> spk_volume_delegate,
		std::shared_ptr<YCKTestSpeakerDelegate> test_spk_delegate) = 0;
	virtual void testSpeakerFinish() = 0;
	virtual bool testMicrophoneStart(const std::string& pcm_file) = 0;
	virtual void testMicrophoneFinish() = 0;
	//麦克风设备
	virtual bool selectMicrophone(const YCKDeviceId& selected) = 0;
	virtual bool selectDefaultMicrophone() = 0;
	virtual std::vector<YCKDeviceId> getMicrophoneList() = 0;
	virtual YCKDeviceId getSelectedMicrophone() = 0;
	virtual bool setMicrophoneOn(std::shared_ptr<YCKAudioDeviceVolumeDelegate> mic_volume_delegate) = 0;
	virtual void setMicrophoneOff() = 0;
	virtual bool getMicrophoneOn() = 0;
	virtual float getMicrophoneVolume(const YCKDeviceId& devId) = 0;
	virtual void setMicrophoneVolume(const YCKDeviceId& devId, float volume) = 0;// 0.0 (silence) => 1.0 (full level)
	virtual float getCachedSelectedMicVolume() =0;
	virtual bool checkAudioPlugin() = 0;
	virtual void cleanAudioPlugin() = 0;

};
#endif // !YCK_CALL_DEVICE_MANAGER_H
