//
// Created by shixiaobo on 2020/7/10.
//

#ifndef NEOTRINO_RECORDERMANAGERPROTOCOL_H
#define NEOTRINO_RECORDERMANAGERPROTOCOL_H
#ifdef SDK_SIMPLE_INCLUDE
#include "common.h"
#include "YCKGlobalDefs.h"
#include "YCKCallManagerProtocol.h"
#include "ScreenRecorderExport.h"
#include "ScreenGrabProtocol.h"
#else
#include <YCKSdwan/common.h>
#include <YCKit/YCKGlobalDefs.h>
#include <YCKit/Call/YCKCallManagerProtocol.h>
#include <ScreenRecorder/ScreenRecorderExport.h>
#include <ScreenRecorder/ScreenGrabProtocol.h>
#endif
#include "memory"
enum RecorderCallbackStatus{
    onStartSuccess = 1,
    onStartFail,
    onStopSuccess,
    onStopFail
};
enum audioSource
{
    KitNative=0,
    audioPlugin,
};
class RecorderManagerDelegate{
public:
    virtual void onStart(RecorderCallbackStatus status) = 0;
    virtual void onStop(RecorderCallbackStatus status,std::string path) = 0;
};

namespace RecorderManagerUtility {

class Progress {
public:
    virtual void OnProgress(int64_t current, int64_t total, bool& stop_convert) = 0;
};

/**
 * Convert media file format.
 * @param src_path Source file path.
 * @param dest_path Destination file path.
 * @param progress - Convert progress.
 */
DLL_DECL_SR bool ConvertFile(const std::string& src_path, const std::string& dest_path, std::shared_ptr<Progress> progress);

/**
 * Merge multiple media files to one.
 * @param src_paths Source file path.
 * @param dest_path Destination file path.
 * @param progress - Convert progress.
 */
DLL_DECL_SR bool MergeFiles(const std::vector<std::string>& src_paths, const std::string& dest_path, std::shared_ptr<Progress> progress);

/**
 * Get media file average bitrate.
 * @param path Media file path.
 */
DLL_DECL_SR int64_t GetAverageBitrate(const std::string& path);
};

class DLL_DECL_SR RecorderManagerProtocol : public ScreenGrabProtocol {
public:
    static std::shared_ptr<RecorderManagerProtocol> init(std::shared_ptr<YCKCallManagerProtocol> callManager);
    
	virtual void option(float scalingRatio = 1, 
        int64_t avg_bitrate = 3 << 10,
        int frameRate = 30, 
        YCKCallVideoPreset video_preset = YCKCallVideoPresetDefault, 
        VideoCodecCategory codec_id = NV_AUTO) = 0;
	/**
     * 录制开始
     */
    virtual void start(const std::string& path, const std::string& windows_title = "") = 0;

    /**
     * 录制结束
     */
    virtual void stop() = 0;

	/**
	 * 是否开始录制
	 */
	virtual bool isStarted() = 0;

    /**
     * 添加结果回调
     * @param delegate
     */
    virtual void addDelegate(std::shared_ptr<RecorderManagerDelegate> delegate) = 0;

    //切换音频源
    virtual void SwitchAudioSource(audioSource type) =0;
    virtual ~RecorderManagerProtocol() = default;
};
#endif //NEOTRINO_RECORDERMANAGERPROTOCOL_H
