#!/bin/bash
if [ $# -lt 2 ]; then
	echo "Usage: $0 <to_fix_file> <QT_INSTALL_DIR>"
	exit 1;
fi
if [ ! -e $1 ]; then
	echo "Error: to fix file: $1 doesn't exist!"
	exit 2;
fi
if [ ! -e $2 ]; then
	echo "Error: QT_INSTALL_DIR $2 doesn't exist!"
	exit 2;
fi
FIX_FILE=$1
QT_INSTALL_DIR=$2
cd `dirname $0`
BINPATH=`pwd`
echo "Fix path of $FIX_FILE with $QT_INSTALL_DIR and current dir: $BINPATH"
BAK_EXT=".fix_path_bak"
if [ -e $FIX_FILE.$BAK_EXT ]; then
	mv $FIX_FILE.$BAK_EXT $FIX_FILE
fi
cp $FIX_FILE $FIX_FILE.$BAK_EXT
#replace previous QtDir to QT_INSTALL_DIR and previous build dir to BINPATH
sed -i".tmp" "s|/Users/gaiyangjun/Qt/5.15.2/clang_64|$QT_INSTALL_DIR|g" $FIX_FILE
sed -i".tmp" "s|/Users/gaiyangjun/work/nvqtav|$BINPATH|g" $FIX_FILE
sed -i".tmp" "s|/Volumes/sources/client/cxx/build-QtAV-Desktop_Qt_5_14_2_clang_64bit-Release|$BINPATH|g" $FIX_FILE
sed -i".tmp" "s|/home/skyinfall/Qt/5.15.2/gcc_64|$QT_INSTALL_DIR|g" $FIX_FILE
exit $?
