#!/bin/bash

SCRIPT_DIR=`dirname $0`

cd ${SCRIPT_DIR}
CURRENT_DIR=`pwd`

cd -

if [ $# -lt 1 ]; then
    echo -e "Usage: \t $0 <QT_INSTALL_DIR>"
    echo -e " e.g.: \t $0 ~/Qt5.14.2/5.14.2/clang_64/"
    exit 1;
fi
QT_INSTALL_DIR=$1
if [ ! -e $QT_INSTALL_DIR/lib ]; then
    echo "QT_INSTALL_DIR isn't correct. $QT_INSTALL_DIR/lib doesn't exist";
    exit 2;
fi
if [ ! -e $QT_INSTALL_DIR/qml ]; then
    echo "QT_INSTALL_DIR isn't correct. $QT_INSTALL_DIR/qml doesn't exist";
    exit 2;
fi

bash fix_path.sh clang_64/lib/QtAV.framework/Resources/QtAV.prl `dirname $QT_INSTALL_DIR//.`
bash fix_path.sh clang_64/lib/QtAVWidgets.framework/Resources/QtAVWidgets.prl `dirname $QT_INSTALL_DIR//.`

cp -f -R clang_64/lib/* $QT_INSTALL_DIR/lib
cp -f -R clang_64/mkspecs/* $QT_INSTALL_DIR/mkspecs
cp -f -R clang_64/qml/* $QT_INSTALL_DIR/qml
