#!/bin/bash
if [ $# -lt 1 ]; then
    echo -e "Usage: \t $0 <QT_INSTALL_DIR>"
    echo -e " e.g.: \t $0 ~/Qt5.14.2/5.14.2/clang_64/"
    exit 1;
fi
QT_INSTALL_DIR=$1
if [ ! -e $QT_INSTALL_DIR/lib ]; then
    echo "QT_INSTALL_DIR isn't correct. $QT_INSTALL_DIR/lib doesn't exist";
    exit 2;
fi
if [ ! -e $QT_INSTALL_DIR/qml ]; then
    echo "QT_INSTALL_DIR isn't correct. $QT_INSTALL_DIR/qml doesn't exist";
    exit 2;
fi

rm -rf ${QT_INSTALL_DIR}/lib/QtAV.framework
rm -f ${QT_INSTALL_DIR}/lib/libQt5AV.dylib
rm -rf ${QT_INSTALL_DIR}/include/QtAV
rm -f ${QT_INSTALL_DIR}/mkspecs/features/av.prf
rm -f ${QT_INSTALL_DIR}/mkspecs/modules/qt_lib_av*.pri
rm -rf ${QT_INSTALL_DIR}/lib/QtAVWidgets.framework
rm -f ${QT_INSTALL_DIR}/lib/libQt5AVWidgets.dylib
rm -rf ${QT_INSTALL_DIR}/include/QtAVWidgets
rm -f ${QT_INSTALL_DIR}/mkspecs/features/avwidgets.prf
rm -f ${QT_INSTALL_DIR}/mkspecs/modules/qt_lib_avwidgets*.pri
rm -rf ${QT_INSTALL_DIR}/qml/QtAV
