/*
 * NVExternalAudioStreamProtocol.h
 *
 *  Created on: Sep 4, 2020
 *      Author: dengminhao@axzt.net
 */

#ifndef YCKIT_YCKIT_AUDIO_NVEXTERNALAUDIOSTREAMPROTOCOL_H_
#define YCKIT_YCKIT_AUDIO_NVEXTERNALAUDIOSTREAMPROTOCOL_H_


#pragma once

#ifdef SDK_SIMPLE_INCLUDE
#include "common.h"
#include "YCKGlobalDefs.h"
#include "YCKitExport.h"
#else
#include <YCKSdwan/common.h>
#include <YCKit/YCKGlobalDefs.h>
#include <YCKit/YCKitExport.h>
#endif

/**
 * Accept audio stream outside audio engine.
 * Now we only accept audio fmt AV_SAMPLE_FMT_S16 (short)
 */
class DLL_DECL NVExternalAudioStreamProtocol{
public:
	/**
	 * Append more audio data.
	 * return true if accepted. false if not. (buffer full or invalid state)
	 */
	virtual bool append(const byte* data, size_t dataSizeInByte) = 0;
	/**
	 *  Accepted value range: [0~2]
	 *  1.0 means origin volume. 0~1 lighter, 1~2 louder.
	 */
	virtual bool setVolume(const float vol) = 0;

	/**
	 * clean any buffer, used in the case we adjusted play position.
	 */
	virtual void clean() = 0;
	/**
	 * close stream. Will never use this stream and isValid will become false.
	 */
	virtual void close() = 0;

	virtual bool isValid() = 0;

	virtual int getStreamIndex() const = 0;

	virtual ~NVExternalAudioStreamProtocol()=default;

};


#endif /* YCKIT_YCKIT_AUDIO_NVEXTERNALAUDIOSTREAMPROTOCOL_H_ */
