#ifndef NV_D3D11VP_H
#define NV_D3D11VP_H

#ifdef SDK_SIMPLE_INCLUDE
#include "../YCKitExport.h"
#include "NVColor.h"
#else
#include "YCKit/YCKitExport.h"
#include "../NVColor.h"
#endif
#include "dxcompat.h"
#include <d3d11.h>
#include <wrl/client.h>

using namespace Microsoft::WRL;

namespace dx {

class DLL_DECL D3D11VP
{
public:
    // brightness, contrast, hue, saturation, rotation, source/dest rect
    D3D11VP(ComPtr<ID3D11Device> dev);
    void setOutput(ID3D11Texture2D* tex);
    void setSourceRect(const RECT& r);
    // input color space and range
    void setColorSpace(ColorSpace value);
    void setColorRange(ColorRange value);
    bool process(ID3D11Texture2D *texture, int index);
	bool is_create_processor_fail() const { return create_processor_fail; }
private:
    bool ensureResource(UINT width, UINT height, DXGI_FORMAT format);

    ComPtr<ID3D11Device> m_dev;
    ComPtr<ID3D11Texture2D> m_out;
    ComPtr<ID3D11VideoDevice> m_viddev;
    ComPtr<ID3D11VideoProcessorEnumerator> m_enum;
    ComPtr<ID3D11VideoProcessor> m_vp;
    ComPtr<ID3D11VideoProcessorOutputView> m_outview;
    UINT m_w, m_h; //enumerator
    ColorSpace m_cs;
    ColorRange m_range;
	RECT m_srcRect;
	bool create_processor_fail = false;
};
} //namespace dx

#endif //NV_D3D11VP_H
