﻿//
//  NVKGlobalDefs.h
//  NeuVisionKit
//
//  Created by 徐家骏 on 2017/6/12.
//  Renamed by dengminhao 2021/2/22
//

#ifndef NVKGlobalDefs_h
#define NVKGlobalDefs_h

enum YCKCallMode{
    YCKCallModeOneToOne       = 1,
    YCKCallModeMultiple       = 2,
};

enum YCKCallAudioPreferredMode
{
    YCKCallAudioPreferredModeNormal        = 1,
    YCKCallAudioPreferredModeLowDelay      = 2,
    YCKCallAudioPreferredModeQuality       = 3,
};

enum YCKCallVideoPreferredMode
{
    YCKCallVideoPreferredModeNormal       = 1,
    YCKCallVideoPreferredModeFluency      = 2,
    YCKCallVideoPreferredModeClear        = 3,
};

/**
 音频采样率
 */
enum YCKAudioSampleRate {
    /**
     *  默认采样率
     */
    YCKAudioSampleRateDefault             = 48000,

    YCKAudioSampleRate8000HZ              = 8000,

    YCKAudioSampleRate16000HZ             = 16000,

    YCKAudioSampleRate24000HZ             = 24000,

    YCKAudioSampleRate48000HZ             = 48000,
};

/**
 音频采样长度
 */
enum YCKAudioFrameMs {
    /**
     *  默认采样率
     */
    YCKAudioFrameMs5              = 5,
    
    YCKAudioFrameMs10              = 10,
    
    YCKAudioFrameMs20              = 20,
    
    YCKAudioFrameMs40              = 40,
};



/**
 摄像头
 */
enum YCKVideoCameraPosition {
    YCKVideoCameraPositionUnspecified     = 0,
    YCKVideoCameraPositionBack            = 1,
    YCKVideoCameraPositionFront           = 2,
};


/**
 视频方向
 */
enum YCKVideoOrientation {
    /**
     *  默认方向
     */
    YCKVideoOrientationDefault             = 0,
    /**
     *  垂直方向, home 键朝下
     */
    YCKVideoOrientationPortrait            = 1,
    /**
     *  垂直方向, home 键朝上
     */
    YCKVideoOrientationPortraitUpsideDown  = 2,
    /**
     *  水平方向, home 键在右边
     */
    YCKVideoOrientationLandscapeRight      = 3,
    /**
     *  水平方向, home 键在左边
     */
    YCKVideoOrientationLandscapeLeft       = 4,
};

/**
 *  网络通话音视频质量
 */
enum YCKCallPreset {
    YCKCallPresetLost = 0,
    YCKCallPreset240P = 1,
    YCKCallPreset480P = 2,
    YCKCallPreset720P = 3,
    YCKCallPreset1080P = 4,
    YCKCallPreset2K = 5,
    YCKCallPreset4K = 6,
    YCKCallPresetAudioDefault = 50,
    YCKCallPresetPSTNDefault = 100,
};

/**
 *  网络通话视频质量
 */
enum YCKCallVideoPreset {
    /**
     *  默认视频质量
     */
    YCKCallVideoPresetDefault    = 0,
    /**
     *  低视频质量
     */
    YCKCallVideoPresetLow        = 1,
    /**
     *  中等视频质量
     */
    YCKCallVideoPresetMedium     = 2,
    /**
     *  高视频质量
     */
    YCKCallVideoPresetHigh       = 3,
    /**
     *  480P等级视频质量
     */
    YCKCallVideoPreset480p       = 4,
    /**
     *  720P等级视频质量
     */
    YCKCallVideoPreset720p       = 5,
    YCKCallVideoPreset1080p      = 6,
    YCKCallVideoPreset4k         = 7,
    
};


/**
 *  画面裁剪
 */
enum YCKCallVideoCrop {
    /**
     *  16:9 裁剪
     */
    YCKCallVideoCrop16x9             = 0,
    /**
     *  4:3 裁剪
     */
    YCKCallVideoCrop4x3              = 1,
    /**
     *  1:1 裁剪
     */
    YCKCallVideoCrop1x1              = 2,
    /**
     *  不裁剪
     */
    YCKCallVideoCropNoCrop           = 3,
};


/**
 *  网络通话类型
 */
enum YCKCallMediaType{
    
    YCKCallMediaTypeUnknown = 0,
    /**
     *  音频通话
     */
    YCKCallMediaTypeAudio   = 1,
    /**
     *  视频通话
     */
    YCKCallMediaTypeVideo   = 2,
};

/**
*  网络通话中发生的事件
*/
enum YCKCallEvent {
    
    YCKCallEventStopAcceptVideoForLowBandwidth = 10,
    
    YCKCallEventInterruptedBySystemCall = 20,
    
    YCKCallEventInterruptedBySystemCallRecover = 21,
    
    YCKCallEventPoorNetworkLocal = 30,
    
    YCKCallEventPoorNetworkRemote = 40,
    
    YCKCallEventCameraOn  = 50,
    
    YCKCallEventCameraOff  = 51,
    
    YCKCallEventMicMuted  = 60,
    
    YCKCallEventMicOpen = 61,
    
    YCKCallEventEnterBackground = 70,
    
    YCKCallEventEnterForeground = 71,
};

/**
 *  视频混频模式, 用于互动直播连麦时的视频混频参数设置
 */
enum YCKCallVideoMixMode {
    /**
     *  右侧纵排浮窗(画中画)
     */
    YCKCallVideoMixModeFloatingRightVertical  = 0,
    /**
     *  左侧纵排浮窗(画中画)
     */
    YCKCallVideoMixModeFloatingLeftVertical   = 1,
    /**
     *  分格平铺, 显示完整画面, 不裁剪
     */
    YCKCallVideoMixModeLatticeAspectFit       = 2,
    /**
     *  分格平铺, 填满区域, 可能裁剪
     */
    YCKCallVideoMixModeLatticeAspectFill      = 3,
};

/**
 *  YC 网络通话 Error Domain
 */
//#include <string>
//extern std::string const YCKCallErrorDomain;

/**
 *  网络通话错误码
 */
enum YCKCallErrorCode {
    /**
     *  网络通话没有启动
     */
    YCKCallErrorCodeNotStarted         = 20001,
    /**
     *  操作失败
     */
    YCKCallErrorCodeOperationFailed    = 20002,
    /**
     *  超过最大允许直播节点数量
     */
    YCKCallErrorCodeBypassSetExceedMax = 20202,
    
    /**
     *  必须由主播第一个开启直播
     */
    YCKCallErrorCodeBypassSetHostNotJoined = 20203,
    
    /**
     *  互动直播服务器错误
     */
    YCKCallErrorCodeBypassSetServerError = 20204,
    
    /**
     *  互动直播其他错误
     */
    YCKCallErrorCodeBypassSetOtherError = 20205,
    
    /**
     *  互动直播服务器没有响应
     */
    YCKCallErrorCodeBypassSetNoResponse = 20404,
    
    /**
     *  重连过程中无法进行相关操作，稍后再试
     */
    YCKCallErrorCodeBypassReconnecting = 20405,
    
    /**
     *  互动直播设置超时
     */
    YCKCallErrorCodeBypassSetTimeout   = 20408,
    
    /**
     *  与音视频服务器连接断开
     */
    YCKCallErrorCodeServerDisconnected = 20409,
    
    /**
     *  对方超时离开了房间
     */
    YCKCallErrorCodePeerLeftForTimeout = 20410,
    
    /**
     *  音频设备异常
     */
    YCKCallErrorCodeAudioDeviceError   = 20411,
    
    /**
     *  被踢出了音视频
     */
    YCKCallErrorCodeBeKicked           = 20412,
    
    
};

#ifndef NV_VIDEO_CODEC_ENUM
#define NV_VIDEO_CODEC_ENUM
/**
 * 视频编码器类型
 */
enum VideoCodecCategory {
	NV_NONE = -1,
	NV_AUTO = 0,
	NV_H264 = 1,
	NV_H265 = 2,
	NV_VP8 = 3,
	NV_VP9 = 4,
	NV_AV1 = 5
};

enum VideoCodecSupport {
	NV_CODEC_SUP_NONE = 0,
	NV_SOFTWARE_CODEC = 1,
	NV_HARDWARE_CODEC = 2,
	NV_BOTH_SH_CODEC = 3
};

#endif

enum VideoDecoderHardwareAcceleratedLevel {
	NV_DECODE_ACC_NONE = 0,
	NV_HARDWARE_WITH_MEMORY_COPY = 1,
	NV_HARDWARE_WITHOUT_MEMORY_COPY = 2
};

enum RateControlMethod {
    RateControlVBR = 0,
    RateControlCBR = 1,
    RateControlCQP = 2,
};

enum VideoContentType {
    VideoContentCamera = 0, /*!< 摄像头 */
    VideoContentScreen = 1, /*!< 屏幕 */
};

/*! 虚拟背景算法. */
enum VirtualBackgroundAlgorithm {
    VirtualBackgroundNone = 0, /*!< 禁用虚拟背景 */
    VirtualBackgroundClassical = 1, /*!< 传统图像处理算法,仅仅用于绿幕 */
    VirtualBackgroundDeep = 2, /*!< 深度学习算法 */
};

/*! Screen share mode. */
enum ScreenShareMode {
    kScreenShareDocument = 0, /*!< Share document content. 对应清晰模式. */
    kScreenShareVideo = 1,    /*!< Share video content. 对应流畅模式. */
    kScreenShareModeMax = 2,
};

enum VideoCodecMode {
	NV_VIDEO_CODEC_AUTO = 0,		/*auto*/
	NV_VIDEO_CODEC_SOFTWARE = 1		/*软件编解码*/
};

#endif /* NVKGlobalDefs */
