﻿#pragma once
/*
 * NVVideoTransformMeta.h
 *
 *  Created on: Apr 29, 2022
 *      Author: dengminhao@axzt.net
 */

#ifndef YCKIT_YCKIT_VIDEO_NVVIDEOTRANSFORMMETA_H_
#define YCKIT_YCKIT_VIDEO_NVVIDEOTRANSFORMMETA_H_
#ifdef SDK_SIMPLE_INCLUDE
#include "YCKitExport.h"
#else
#include <YCKit/YCKitExport.h>
#endif
#include <cassert>
#include <cstdlib>
#include <cstdint>
#include <string>

class DLL_DECL NVVideoTransformMeta {
public:
	//used locally.
	bool noMetaPresent;
	//mirror Horizontal
    bool mirrorH;
	//mirror Vertical
	bool mirrorV;

	struct TransMatrix{
		float m00;
		float m01;
		float m02;
		float m10;
		float m11;
		float m12;
		float m20;
		float m21;
		float m22;
	};
	static_assert(sizeof(TransMatrix) == sizeof(float[9]),"transmatrix must equal to a float array[9]");
	//用标志位判断是否存在这个metrix.
	//这样如果忽略matrix做大幅更新或者可以忍受matrix更新时可能出现的一帧的闪烁，
	//可以直接同步读写
	bool hasTransMatrix;
	
	union {
		TransMatrix tMatrix;
		float mdata[9];
	};
};




#endif /* YCKIT_YCKIT_VIDEO_NVVIDEOTRANSFORMMETA_H_ */
