﻿//
//  YCKCallInfo.h
//  YCKit
//
//  Created by 徐家骏 on 2019/7/2.
//  Copyright © 2019 徐家骏. All rights reserved.
//

#pragma once

#include <unordered_map>
#include <unordered_set>
#include <set>
#ifdef SDK_SIMPLE_INCLUDE
#include "common.h"
#include <memory>
#include "YCKGlobalDefs.h"
#include "nlohmann/json.hpp"
#include "YCKNetworkReachability.h"
#else
#include <YCKSdwan/common.h>
#include <YCKSdwan/Utils/YCKNetworkReachability.h>
#include <YCKit/YCKGlobalDefs.h>
#include "YCKExternal/YCKExternal/json/single_include/nlohmann/json.hpp"
#endif


using nlohmann::json;

enum YCKParticipantState {
    YCKParticipantStateIdle = 0,
    YCKParticipantStateCalling = 1,
    YCKParticipantStateCalled = 2,
    YCKParticipantStateIncall = 4
};

enum YCKParticipantEvent {
    YCKParticipantEventInvite = 1,
    YCKParticipantEventRecvInvite = 2,
    YCKParticipantEventCancel = 3,
    YCKParticipantEventRecvCancel = 4,
    YCKParticipantEventAccept = 5,
    YCKParticipantEventRecvAccept = 6,
    YCKParticipantEventReject = 7,
    YCKParticipantEventRecvReject = 8,
    YCKParticipantEventBusy = 9,
    YCKParticipantEventRecvBusy = 10,
    YCKParticipantEventEnd = 11,
    YCKParticipantEventRecvEnd = 12,
    YCKParticipantEventTimout = 13,
    YCKParticipantEventRing = 14
};

class YCKCallInfo {
public:
    YCKCallInfo();

public:
    PROPERTY(nonatomic) YCKCallMode mode;
    PROPERTY(nonatomic) int64_t session_id;
    PROPERTY(nonatomic) int64_t me;
    PROPERTY(nonatomic) int64_t peer;
    PROPERTY(nonatomic) YCKNetworkReachabilityStatus net;
    PROPERTY(nonatomic) YCKCallMediaType mediaType;
    PROPERTY(nonatomic, strong) std::vector<int64_t> callees;
    PROPERTY(nonatomic, strong) std::vector<std::pair<std::string, std::string>> relays;
    YCKCallPreset subType;
    

    PROPERTY(nonatomic) int64_t lastChangeTime; //多方时的状态变化时间
    int32_t	me_idx;	//自己在member_state里的idx
    PROPERTY(nonatomic)   int64_t          lastRelayChangeTime; //Relay列表有更改时的时间戳，客户端每次报告relay performance的时候带上此时间戳，服务器发现上次更改客户端还没收到的话，就需要重发relay更新信令


    void clear();

    const std::shared_ptr<const std::unordered_map<int64_t,int>> activeParticipants();

    void setParticipantInfo(std::shared_ptr<json> info);
    std::shared_ptr<json> participantInfo(){return _participantInfo;}

    std::vector<int64_t> newJoin();

    std::vector<int64_t> newLeave();

    static bool isHiddenServer(int64_t uid);

    static bool isHiddenServer(const std::string &uidStr);

protected:
    PROPERTY(nonatomic, strong) std::shared_ptr<json> previousParticipantInfo;
    // 还是定义成 json 对象
    PROPERTY(nonatomic, strong) std::shared_ptr<json> _participantInfo;  //多方时的成员信息
};
