//
//  YCKKickInfo.h
//  YCKSdwan
//
//  Created by 徐家骏 on 2019/6/17.
//  Copyright © 2019 徐家骏. All rights reserved.
//

#pragma once
#ifdef SDK_SIMPLE_INCLUDE
#include "common.h"
#else
#include <YCKSdwan/common.h>
#endif
/**
 *  被踢下线的原因
 */
enum YCKKickReason
{
    /**
     *  被另外一个客户端踢下线 (互斥客户端一端登录挤掉上一个登录中的客户端)
     */
    YCKKickReasonByClient = 1,
    /**
     *  被服务器踢下线
     */
    YCKKickReasonByServer = 2,
    /**
     *  被服务器限制访问, 一般是由用户举报引起一定时段的禁用
     */
    YCKKickReasonByServerLimitAccess = 3,
    /**
     *  被另外一个客户端手动选择踢下线
     */
    YCKKickReasonByClientManually   = 4,
};


class YCKKickInfo {
public:
PROPERTY(nonatomic, assign)   YCKKickReason   reason;

PROPERTY(nonatomic, assign)   int64_t      timestamp;

PROPERTY(nonatomic, strong)   std::string        model;

PROPERTY(nonatomic, strong)   std::string        ip;

};
